import pandas as pd
import json
from networkx.readwrite import json_graph

def export_profile(profile, path):
    df = pd.DataFrame(profile)
    df.to_csv(path)
    print(f'Profile saved to {path}')


def export_distances(distances, path):
    df = pd.DataFrame(distances)
    df.to_csv(path)
    print(f'Distances saved to {path}')


def export_coordinates(distances, path):
    df = pd.DataFrame(distances)
    df.to_csv(path)
    print(f'Distances saved to {path}')


def export_tree(tree, path):
    # Save as JSON
    data = json_graph.node_link_data(tree)
    with open(path, "w") as f:
        json.dump(data, f)

    print(f'Tree saved to {path}')


def export_points(points, path):
    df = pd.DataFrame(points)
    df.to_csv(path)
    print(f'Points saved to {path}')

def export_radius(points, path):
    df = pd.DataFrame(points)
    df.to_csv(path)
    print(f'Points saved to {path}')

